'==========================================================================
' NAME: ShareMethods
'
' COMMENT: Script methods for working with network shares
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'==========================================================================
'Constants for setting permissions
'Security Descriptor Control Flag constant
const SE_DACL_PRESENT 		  = &h4
'AceType constants
const ACCESS_ALLOWED_ACE_TYPE = &h0
const ACCESS_DENIED_ACE_TYPE  = &h1
'AccessMask Constants
const FILE_ALL_ACCESS         = &h1f01ff
const FOLDER_ADD_SUBDIRECTORY = &h000004
const FILE_DELETE             = &h010000
const FILE_DELETE_CHILD       = &h000040
const FOLDER_TRAVERSE         = &h000020
const FILE_READ_ATTRIBUTES    = &h000080
const FILE_READ_CONTROL       = &h020000
const FOLDER_LIST_DIRECTORY   = &h000001
const FILE_READ_EA            = &h000008
const FILE_SYNCHRONIZE        = &h100000
const FILE_WRITE_ATTRIBUTES   = &h000100
const FILE_WRITE_DAC          = &h040000
const FOLDER_ADD_FILE         = &h000002
const FILE_WRITE_EA           = &h000010
const FILE_WRITE_OWNER        = &h080000

'AceFlags constants
const OBJECT_INHERIT_ACE 	  = &h1
const CONTAINER_INHERIT_ACE	  = &h2
const NO_PROPAGATE_INHERIT_ACE= &h4
const INHERIT_ONLY_ACE		  = &h8
const INHERITED_ACE			  = &h10

'File share constants
Const FILE_SHARE 			  =&h0
Function CreateShare(strShareName,strPath,strComputer,nConnections)
'==========================================================================
'	Name: CreateShare
'	IN: strShareName - name of share to create
'		strPath - Local path spec of share
'		strComputer - Server on which to create the share
'		nConnections - Maximum number of connections
'	Out - Return code/message
'	Descrition:  Creates a network shared folder
'==========================================================================

	Dim oWMIService
	Dim oShare
	Dim oAceAdmin
	Dim oSD
	Dim nRetVal
	Dim strDescrption
	Dim strReturn
	
	'Description
	strDescription = "Shared folder for provisioning with MPS"
	'Connect to the Windows Management Instrumentation service
	'Create the service setting impersonation level
	'to use the credentials of the caller
	'and authentication level to encrypt COM packets for remote calls
	Set oWMIService = GetObject("winmgmts:{impersonationLevel=impersonate,authenticationLevel=pktPrivacy}\\" & strComputer & "\root\CIMV2")
	'Create a secutiry Descriptor
	Set oSD = oWMIService.Get("Win32_SecurityDescriptor")
	'Create a new share object
	Set oShare = oWMIService.get("Win32_Share")
	'Build the ACE
	'strComputer = oNet.ComputerName
	nAccessMask = FILE_ALL_ACCESS
	nAceFlags = OBJECT_INHERIT_ACE + CONTAINER_INHERIT_ACE
	Set oAceAdmin = CreateAce(oWMIService,"Administrators",strComputer,nAccessMask,nAceFlags)
	oSD.DACL=Array(oAceAdmin)
	'Create the share
	nRetVal = oShare.Create(strPath,strShareName,FILE_SHARE,nConnections,strDescription,,oSD)
	If nRetVal <> 0 Then
		strErr = " Share creation failed with the following error code: "
		Select Case nRetVal
			Case 2
				strReturn = strErr & nRetVal & " : Access Denied"
			Case 8
				strReturn = strErr & nRetVal & " : Unknown Failure"
			Case 9
				strReturn = strErr & nRetVal & " : Invalid Name"
			Case 10
				strReturn = strErr & nRetVal & " : Invalid Level"
			Case 21
				strReturn = strErr & nRetVal & " : Invalid Parameter"
			Case 22
				strReturn = strErr & nRetVal & " : Duplicate Share"
			Case 23
				strReturn = strErr & nRetVal & " : Redirected Path"
			Case 24
				strReturn = strErr & nRetVal & " : Unknown Device or Directory"
			Case 25
				strReturn = strErr & nRetVal & " : Net name not Found"
		End Select
		CreateShare=strReturn
		Exit Function
	End If
	strReturn = "Created share '" & strShareName & " on " & strPath & "."
	CreateShare=strReturn

End Function

Function CreateAce(objIn,strTrustee,strDomain,nAccMask,nAceFlag)
'===================================================
'	NAME:	CreateAce
'	IN:		objIn - Instance of WMI \Root\CIMV2 namespace
'			strTrustee - User or Group name
'			strDomain - Domain or Computer Name
'			nAccMask - AccessMask bit mask
'			nAceFlag - Ace Flag bitmask
'	OUT:	AccessControlEntry object
'===================================================	
	'Delcare variables
	Dim objAcct
	Dim objSID
	Dim objTrustee
	Dim objACE
	dim strClass
	'Determines Win32_account class to use
	strClass = getClass(strTrustee,strDomain)
	'Fetch a reference to the account for the trustee
	Set objAcct = objIn.get("Win32_" & strClass & ".Domain='" & strDomain & "',Name='" & strTrustee & "'")
	'Fetch a reference to teh SID object for the account
	Set objSID = objIn.get("Win32_SID='" & objAcct.SID & "'")
	
	'Create a trustee object
	Set objTrustee = objIn.get("Win32_Trustee")
	objTrustee.Domain    = objSID.ReferencedDomainName
	objTrustee.Name      = objSID.AccountName
	objTrustee.SID       = objSID.BinaryRepresentation
	objTrustee.SidLength = objSID.SidLength
	objTrustee.SIDString = objSID.SID
		
	'Create an AccessControlEntry(ACE)
	Set objACE = objIn.get("Win32_ACE")
	objACE.Trustee = objTrustee
	objACE.AccessMask = nAccMask
	objACE.AceType = ACCESS_ALLOWED_ACE_TYPE
	objACE.AceFlags = nAceFlag
	
	Set CreateAce = objACE

End Function

Function getClass(strTrustee,strComputerName)
'===================================================
'	NAME:	getClass
'	IN:		strTrustee - User or Group name
'			strComputerName - Domain or Computer Name
'	OUT:	Class of Win32_account to use
'===================================================	
	Dim oTemp
	Dim strClass
	'Special case for 'SYSTEM' account
	If strTrustee = "SYSTEM" Then 
		WScript.Echo strTrustee
		strClass = "SystemAccount"
		getClass = strClass
		Exit Function
	Else
		'get trustee account object
		WScript.Echo strTrustee
		Set oTemp = GetObject("WinNT://" & strComputerName & "/" & strTrustee)
		If IsObject(oTemp) Then
			'Determine if User or Group
			strClass = oTemp.class
			'if user, set to Win32 name
			If strClass = "User" Then strClass = "UserAccount"
			getClass = strClass
		Else
			Write oLogFile, "Object not found for Trustee. Returnvalue was (" & Err.number & ", " & Err.Description & ")",Err_FAIL,bDebug
			WScript.Quit
		End If
	End If
End Function

